##############################################################
# file:     e_conomic_proc.t         #
# Contains utilities for connecting to e-conomic via HTTP protocol 
# Created 2015-10-20 by Angel Quintana
# (C) farmerswife
##############################################################

namespace eval e_conomic {
  # test on windows
  variable v_accessid
  variable v_appid
  variable HTTP_RESPONSES

  proc register {accessid appid} {
    variable v_accessid
    variable v_appid
    variable HTTP_RESPONSES

    package require tls
    package require http
    ::http::register https 443 ::tls::socket

    set v_accessid $accessid
    set v_appid $appid

    set HTTP_RESPONSES [list]

    lappend HTTP_RESPONSES [list "200" "Query Was correct"]
    lappend HTTP_RESPONSES [list "201" "Value Inserted"]
    lappend HTTP_RESPONSES [list "400" "You're sending invalid data. The response will include a description of what's wrong."]
    lappend HTTP_RESPONSES [list "401" "Not authorized: You've either sent an invalid token or no token at all."]
    lappend HTTP_RESPONSES [list "404" "Not found: The resource you requested could not be found."]
    lappend HTTP_RESPONSES [list "412" "There was a specific problem with the data you sent. More information is included in the response."]
    lappend HTTP_RESPONSES [list "500" "Server error: e-conomics is not accessible."]

  }

  proc get_customers {args} {
    set filter [generic:get_opt_arg $args "-filter" ""]
    set demo [generic:get_opt_arg $args "-demo" "false"]
    set cus_number [generic:get_opt_arg $args "-cus_number" ""]
     
    variable v_accessid
    variable v_appid
    
    if {$cus_number == ""} {
      set url "https://restapi.e-conomic.com/customers/"
      set method "GET"
      set header_list [list "accessid" "$v_accessid" "appid" "$v_appid" "filter" "$filter"]
      set fp [::http::geturl $url -method $method -headers $header_list]
    } else {
      set url "https://restapi.e-conomic.com/customers/${cus_number}"
      set method "GET"
      set header_list [list "accessid" "$v_accessid" "appid" "$v_appid"]
      set fp [::http::geturl $url -method $method -headers $header_list]
    }
    set status [::http::status $fp]
    set ncode [::http::ncode $fp]
    set json [::http::data $fp]
    return [list $ncode $json]
  }

  proc insert_customer {content} {
    variable v_accessid
    variable v_appid

    set type "application/json"
    set method "POST"
    set url "https://restapi.e-conomic.com/customers"
    set header_list [list "accessid" "$v_accessid" "appid" "$v_appid"]
    set fp [::http::geturl $url -method $method -type $type -headers $header_list -query $content]
  
    set status [::http::status $fp]
    set ncode [::http::ncode $fp]
    set json [::http::data $fp]
    return [list $ncode $json]
  }


  proc update_customer {cus_number content args} {
    set filter [generic:get_opt_arg $args "-filter" ""]
    set demo [generic:get_opt_arg $args "-demo" "false"]
    variable v_accessid
    variable v_appid

    set type "application/json"
    set method "PUT"
    set url "https://restapi.e-conomic.com/customers/${cus_number}"
    set header_list [list "accessid" "$v_accessid" "appid" "$v_appid"]
    set fp [::http::geturl $url -method $method -type $type -headers $header_list -query $content]
  
    set status [::http::status $fp]
    set ncode [::http::ncode $fp]
    set json [::http::data $fp]
    return [list $ncode $json]
  }

  proc get_customer_group {group_number} {
    variable v_accessid
    variable v_appid

    set url "https://restapi.e-conomic.com/customer-groups/${group_number}"
    set method "GET"
    set header_list [list "accessid" "$v_accessid" "appid" "$v_appid"]
    set fp [::http::geturl $url -method $method -headers $header_list]
    set status [::http::status $fp]
    set ncode [::http::ncode $fp]
    set json [::http::data $fp]
    return [list $ncode $json]    
  }
  
  proc get_payment_terms {terms_key} {
    variable v_accessid
    variable v_appid

    set url "https://restapi.e-conomic.com/payment-terms/${terms_key}"
    set method "GET"
    set header_list [list "accessid" "$v_accessid" "appid" "$v_appid"]
    set fp [::http::geturl $url -method $method -headers $header_list]
    set status [::http::status $fp]
    set ncode [::http::ncode $fp]
    set json [::http::data $fp]
    return [list $ncode $json]    
  }
  proc get_payment_terms_all {} {
    variable v_accessid
    variable v_appid

    set url "https://restapi.e-conomic.com/payment-terms/"
    set method "GET"
    set header_list [list "accessid" "$v_accessid" "appid" "$v_appid"]
    set fp [::http::geturl $url -method $method -headers $header_list]
    set status [::http::status $fp]
    set ncode [::http::ncode $fp]
    set json [::http::data $fp]
    return [list $ncode $json]    
  }
  
  proc get_vat_zone {vat_zone_number} {
    variable v_accessid
    variable v_appid

    set url "https://restapi.e-conomic.com/vat-zones/${vat_zone_number}"
    set method "GET"
    set header_list [list "accessid" "$v_accessid" "appid" "$v_appid"]
    set fp [::http::geturl $url -method $method -headers $header_list]
    set status [::http::status $fp]
    set ncode [::http::ncode $fp]
    set json [::http::data $fp]
    return [list $ncode $json]    
  }
  proc get_vat_zones_all {} {
    variable v_accessid
    variable v_appid

    set url "https://restapi.e-conomic.com/vat-zones/"
    set method "GET"
    set header_list [list "accessid" "$v_accessid" "appid" "$v_appid"]
    set fp [::http::geturl $url -method $method -headers $header_list]
    set status [::http::status $fp]
    set ncode [::http::ncode $fp]
    set json [::http::data $fp]
    return [list $ncode $json]    
  }

  proc get_message {code} {
    variable HTTP_RESPONSES
    set msg_i [lsearch -index 0 $HTTP_RESPONSES $code]
    if {$msg_i != -1} {
      return "[lindex $HTTP_RESPONSES $msg_i 1]"
    }
    return "Code unrecognized: $code"
  }

  # value: FW money (no decimal separation, but 2 last values are decimals)
  proc fix_money {value {decimals 2}} {
    return "[generic:rate_to_dec2 $value]"
  }
}

## Other procs. They will need to be placed in the right place or renamed 
proc economic_customers:buil_json_client {contact} {
# REQUIRED COLUMNS
# currency, customerGroup, name, paymentTerms, vatZone

  # unbuild_address
  # set text_address "[lindex $build_address 0]\n[lindex $build_address 4] [lindex $build_address 1]\n[lindex $build_address 2]"
  set unbuild_address [split [lindex $contact 9] "\n"]
  set address [lindex $unbuild_address 0]
  set zip [lindex $unbuild_address 1]
  set city [lindex $unbuild_address 2]
  set country [lindex $unbuild_address 3]

  # process rows
  set output [list]
  # 37  client_id
  lappend output "\"customerNumber\":[economic_customers:encode_for_json [lindex $contact 37]]"
  # currency must be string 3 char EUR USD DKK
  set currency [economic_customers:get_currency_name [lindex $contact 64]]
  lappend output "\"currency\":\"[economic_customers:encode_for_json $currency]\""

  set paymentTermsNumber [lindex $contact 66]
  set paymentTermsNumber "2"
  set paymentTermsType "2"
  set json_s "\"paymentTermsNumber\":[economic_customers:encode_for_json $paymentTermsNumber]"
  append json_s ",\"paymentTermsType\":[economic_customers:encode_for_json $paymentTermsType]"
#  append json_s ",\"self\":\"https://restapi.e-conomic.com/payment-terms/$paymentTermsNumber\""
  lappend output "\"paymentTerms\":\{$json_s\}"

  set cus_i [lsearch -index 1 [lindex $contact 39] "Debitor Group | Kundegruppe"]
  set custom [lindex $contact 39 $cus_i]
  set option [lindex $custom 2]
  set num [lindex [split $option "/"] 0]
  # This value must exist in 
  set json_s "\"customerGroupNumber\":[economic_customers:encode_for_json $num]"
#  append json_s ",\"self\":\"https://restapi.e-conomic.com/customer-groups/$num\""
  set value "\"customerGroup\":\{$json_s\}"
  lappend output $value

  lappend output "\"address\":\"[economic_customers:encode_for_json $address]\""
  # balance?
  # Co. reg. no. or CVR-nr.
  lappend output "\"corporateIdentificationNumber\":\"[economic_customers:encode_for_json [lindex $contact 65]]\""
  lappend output "\"city\":\"[economic_customers:encode_for_json $city]\""
  lappend output "\"country\":\"[economic_customers:encode_for_json $country]\""
  
  # 78  cc_inv_email
  lappend output "\"email\":\"[economic_customers:encode_for_json [lindex $contact 78]]\""
  # name required!
  lappend output "\"name\":\"[economic_customers:encode_for_json [lindex $contact 4]]\""
  lappend output "\"zip\":\"[economic_customers:encode_for_json $zip]\""
  lappend output "\"telephoneAndFaxNumber\":\"[economic_customers:encode_for_json [lindex $contact 11]]\""

  # CF "VAT Zone" > vatZoneNumber 1
  set cus_i [lsearch -index 1 [lindex $contact 39] "VAT zone | Moms zone"]
  set custom [lindex $contact 39 $cus_i]
  set option [lindex $custom 2]
  set num [lindex [split $option "/"] 0]
  set json_s "\"vatZoneNumber\":[economic_customers:encode_for_json $num]"
#  append json_s ",\"self\":\"https://restapi.e-conomic.com/payment-terms/$num\""
  set value "\"vatZone\":\{$json_s\}"
  lappend output $value

  # 72  con_active
  # "barred":true," > inactive
  set barred "false"
  if {![lindex $contact 72]} {
    set barred "true"
  }
  lappend output "\"barred\":$barred"

  # 6   www
  # "website":"str","
  set website "[lindex $contact 6]"
  lappend output "\"website\":\"$website\""

  # 65  cc_vat_number
  # "website":"str","
  set vatNumber "[lindex $contact 65]"
  lappend output "\"vatNumber\":\"$vatNumber\""

  # 56  cc_max_credit
  # "creditLimit":4567.00,
  set creditLimit "[::e_conomic::fix_money [lindex $contact 56]]"
  lappend output "\"creditLimit\":$creditLimit"


  # OTHER FIELDS NOT IMPLEMENTED
  # layout 
  # attention 
  # customerContact 
  # salesPerson 
  # lastUpdated 

  set output \{[join $output ","]\}

  return $output
}


proc economic_customers:encode_for_json {s} {
  return [string map [list \\ \\\\ \" \\" \n \\n / \\/ \b \\b \r \\r \t \\t] $s]
  # "
}



proc economic_customers:get_currency_name {currency} {
  switch -exact -- $currency {
    "0" {
      return "[lindex [wife::send get_var ::CURRENCY] 1]"
    }
    "1" {
      return "[lindex [wife::send get_var ::CURRENCY2] 1]"
    }
    "2" {
      return "[lindex [wife::send get_var ::CURRENCY3] 1]"
    }
    default {
      error "should not happen this $currency"
      return ""
    }
  }
}

